{ Copyright (C) by Tobias Schwarz, 2003-2007
  Distributed under the GNU General Public License }

unit Logfilesplitter;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs_new,
  StdCtrls, Buttons, Infofenster, Registry, Wildmatch, ExtCtrls, Split_Logfile,
  VistaFuncs, 
  YclZlib, Dialogs; {The YclZlib Unit is part of the Y core library, which is
    copyright by Peter J. Haas. Please visit http://delphi.pjh2.de/ for
    the most recent version of the library, supporting documentation and
    license terms.}

type
  TSplitterForm = class(TForm)
    OpenDialog: TOpenDialog;
    SplitBtn: TBitBtn;
    ExitBtn: TBitBtn;
    AboutBtn: TBitBtn;
    Panel1: TPanel;
    LogfileDialogBtn: TSpeedButton;
    Label1: TLabel;
    Label2: TLabel;
    LogfileEdit: TEdit;
    DomainEdit: TEdit;
    MixDomainsCheck: TCheckBox;
    Label7: TLabel;
    ProviderComboBox: TComboBox;
    Panel2: TPanel;
    Label3: TLabel;
    OutputFileDialogBtn: TSpeedButton;
    OutputFileEdit: TEdit;
    RemoveDomainBox: TCheckBox;
    Panel3: TPanel;
    AnalRecLabel: TLabel;
    FoundLabel: TLabel;
    CompressOutputBox: TCheckBox;
    TimeLabel: TLabel;
    Panel4: TPanel;
    RemoveDomainInRequest: TCheckBox;
    RemovedDomainsLbl: TLabel;
    procedure LogfileDialogBtnClick(Sender: TObject);
    procedure OutputFileDialogBtnClick(Sender: TObject);
    procedure ExitBtnClick(Sender: TObject);
    procedure AboutBtnClick(Sender: TObject);
    procedure SplitBtnClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    { Private-Deklarationen }
    procedure HideAppFormTaskBarButton;
  protected
    procedure CreateParams(var Params: TCreateParams); override;
    procedure WMSyscommand(var Message: TWmSysCommand); message WM_SYSCOMMAND;
  public
    { Public-Deklarationen }
  end;

var
  SplitterForm: TSplitterForm;

implementation

{$R *.DFM}

procedure TSplitterForm.FormCreate(Sender: TObject);
var Registry: TRegistry;
begin
SetOSFont(Self);
HideAppFormTaskBarButton;
Registry:=TRegistry.Create;
Registry.RootKey:=HKEY_CURRENT_USER;
If Registry.KeyExists('Software\Sir_Tobe&Co\LogfileSplitter\LastEntries') then begin
   If Registry.OpenKeyReadOnly('Software\Sir_Tobe&Co\LogfileSplitter\LastEntries') then begin
      If Registry.ValueExists('WindowLeft') then Left:=Registry.ReadInteger('WindowLeft');
      If Registry.ValueExists('WindowTop') then Top:=Registry.ReadInteger('WindowTop');
      If Registry.ValueExists('Logfile') then LogfileEdit.Text:=Registry.ReadString('Logfile');
      If Registry.ValueExists('Provider') then ProviderComboBox.ItemIndex:=Registry.ReadInteger('Provider');
      If Registry.ValueExists('Domain') then DomainEdit.Text:=Registry.ReadString('Domain');
      If Registry.ValueExists('OutputFile') then OutputFileEdit.Text:=Registry.ReadString('OutputFile');
      If Registry.ValueExists('CompressOutput') then CompressOutputBox.Checked:=Registry.ReadBool('CompressOutput');
      If Registry.ValueExists('RemoveDomain') then RemoveDomainBox.Checked:=Registry.ReadBool('RemoveDomain');
      If Registry.ValueExists('MixDomains') then MixDomainsCheck.Checked:=Registry.ReadBool('MixDomains');
      If Registry.ValueExists('RemoveDomainInRequest') then RemoveDomainInRequest.Checked:=Registry.ReadBool('RemoveDomainInRequest');
      Registry.CloseKey;
   end;
end;
Registry.Free;
end;

procedure TSplitterForm.HideAppFormTaskBarButton;
begin
ShowWindow(Application.Handle, SW_HIDE);
SetWindowLong(Application.Handle, GWL_EXSTYLE,
GetWindowLong(Application.Handle, GWL_EXSTYLE) and not WS_EX_APPWINDOW or WS_EX_TOOLWINDOW);
ShowWindow(Application.Handle, SW_SHOW);
end;

procedure TSplitterForm.CreateParams(var Params: TCreateParams);
begin
inherited CreateParams(Params);
Params.ExStyle := Params.ExStyle and not WS_EX_TOOLWINDOW or WS_EX_APPWINDOW;
end;

procedure TSplitterForm.WMSyscommand(var Message: TWmSysCommand);
begin
case (Message.CmdType and $FFF0) of
   SC_MINIMIZE:
   begin
      ShowWindow(Handle, SW_MINIMIZE);
      Message.Result := 0;
   end;
   SC_RESTORE:
   begin
      ShowWindow(Handle, SW_RESTORE);
      Message.Result := 0;
   end;
else
   inherited;
end;
end;

procedure TSplitterForm.LogfileDialogBtnClick(Sender: TObject);
begin
If DirectoryExists(LogfileEdit.Text) then OpenDialog.InitialDir:=LogfileEdit.Text;
If OpenDialog.Execute then LogfileEdit.Text:=OpenDialog.FileName;
end;

procedure TSplitterForm.OutputFileDialogBtnClick(Sender: TObject);
begin
If DirectoryExists(OutputFileEdit.Text) then OpenDialog.InitialDir:=OutputFileEdit.Text;
If OpenDialog.Execute then OutputFileEdit.Text:=OpenDialog.FileName;
end;

procedure TSplitterForm.ExitBtnClick(Sender: TObject);
begin
Close;
end;

procedure TSplitterForm.AboutBtnClick(Sender: TObject);
begin
Info:=TInfofenster.Create(self);
end;

procedure TSplitterForm.SplitBtnClick(Sender: TObject);
var SplitLog: TPreprocessLog;
begin
AnalRecLabel.Caption:='Analysed Records: 0';
FoundLabel.Caption:='Found Records: 0';
RemovedDomainsLbl.Caption:='Removed Domains: 0';
TimeLabel.Caption:='Time: 0 ms';
If FileExists(LogfileEdit.Text) then begin
   If CompressOutputBox.Checked and (ExtractFileExt(OutputFileEdit.Text)<>'.gz') then OutputFileEdit.Text:=OutputFileEdit.Text+'.gz';
   If FileExists(OutputFileEdit.Text) then
      If MessageDlg('File '+OutputFileEdit.Text+' already exists. Overwrite?',mtConfirmation,[mbYes, mbNo],0)=mrYes then begin
         DeleteFile(OutputFileEdit.Text);
      end else Exit;
   DomainEdit.Text:=Trim(DomainEdit.Text);
   SplitLog:=TPreprocessLog.Create;
   If ProviderComboBox.ItemIndex<>2 then begin
      SplitLog.SplitLog:=true;
      Case ProviderComboBox.ItemIndex of
         0: SplitLog.Provider:='1und1';
         1: SplitLog.Provider:='hosteurope';
      end;
      SplitLog.Mix:=MixDomainsCheck.Checked;
      SplitLog.Remove:=RemoveDomainBox.Checked;
   end;
   SplitLog.CompressFilteredLog:=CompressOutputBox.Checked;
   SplitLog.RemoveHost:=RemoveDomainInRequest.Checked;
   SplitLog.Hostname:=DomainEdit.Text;
   SplitLog.PreprocessLog(LogfileEdit.Text,OutputFileEdit.Text,DomainEdit.Text);
   TimeLabel.Caption:='Time: '+IntToStr(SplitLog.ProcessTime)+' ms';
   AnalRecLabel.Caption:='Analysed Records: '+IntToStr(SplitLog.Entries);
   FoundLabel.Caption:='Found Records: '+IntToStr(SplitLog.Found);
   RemovedDomainsLbl.Caption:='Removed Domains: '+IntToStr(SplitLog.HostnamesFound);
   SplitLog.Free;
end;
end;

procedure TSplitterForm.FormClose(Sender: TObject; var Action: TCloseAction);
var Registry: TRegistry;
begin
Registry:=TRegistry.Create;
Registry.RootKey:=HKEY_CURRENT_USER;
If Registry.OpenKey('Software\Sir_Tobe&Co\LogfileSplitter\LastEntries',true) then begin
   Try
      Registry.WriteInteger('WindowLeft',Left);
      Registry.WriteInteger('WindowTop',Top);
      Registry.WriteString('Logfile',LogfileEdit.Text);
      Registry.WriteInteger('Provider',ProviderComboBox.ItemIndex);
      Registry.WriteString('Domain',DomainEdit.Text);
      Registry.WriteString('OutputFile',OutputFileEdit.Text);
      Registry.WriteBool('CompressOutput',CompressOutputBox.Checked);
      Registry.WriteBool('RemoveDomain',RemoveDomainBox.Checked);
      Registry.WriteBool('MixDomains',MixDomainsCheck.Checked);
      Registry.WriteBool('RemoveDomainInRequest',RemoveDomainInRequest.Checked);
   Finally
      Registry.CloseKey;
   end;
end;
Registry.Free;
end;

end.
